#The purpose of this analyse is to relate ICC op content to the speed of the interview. We use round 7 ESS data and timers
#Speed can be mesured in three ways, average speed over the whole interview, average speed excluding the last module, and only module A
#Linking interviewer effect on Speed and Interviewer effect on content data
rm(list=ls())
library(foreign)
library(graphics)
library(stats)
library(plyr)
library(reshape2)
library(lme4)
library(ggplot2)
library(lmerTest)
library(dplyr)
library(tidyr)
##############necessary datasets made in 'modules timers **********
MFB<-as.data.frame(read.csv("./MFBn.csv",header=T,sep=","))
MFC<-as.data.frame(read.csv("./MFCn.csv",header=T,sep=","))
MFD<-as.data.frame(read.csv("./MFDn.csv",header=T,sep=","))
MFE<-as.data.frame(read.csv("./MFEn.csv",header=T,sep=","))
#########################################################
landen1<-c("AT","BE","DE","FR","HU","IE","SI")
landen2<-c("CH","DK","EE","FI","NL","NO","SE","GB")
landen<-as.data.frame(table(MFB$CNTRY))
#no matching possible with GB MF and PSU,

array.Bicc<-c("GINCDIF", "FREEHMS","PSPPSGV","ACTROLG","PSPPIPL","CPTPPOL","PTCPPLT","ETAPAPL","TRSTPRL","TRSTLGL","TRSTPLC","TRSTPLT",
              "TRSTPRT","TRSTEP","TRSTUN","LRSCALE","STFLIFE","STFECO","STFGOV","STFDEM","STFEDU","STFHLTH","EUFTF",
              "IMBGECO","IMUECLT","IMWBCNT")
array.Cicc<-c( "HEALTH","SCLACT","SCLMEET","INPRDSC","RLGATND","PRAY","HAPPY","RLGDGR")
array.Dicc<-c( "PPLSTRD","GVRFGAP","DFEGCON","QFIMEDU","QFIMLNG","QFIMCHR","QFIMWHT","QFIMWSK","QFIMCMT","IMTCJOB","IMBLECO","IMWBCRM",
              "LWDSCWP","RLGUEIM","DFEGHBG")
array.Eicc<-c("ALCBNGE","ETFRUIT","EATVEG","ALCFREQ","DOSPRT")

##################################################################################################################################################
#Bereken ICC binnen elke group van residuele snelheid"



fun.st<-function(x) (x-mean(x,na.rm=T))/sd(x,na.rm=T)



####
# module B
#####
#note in Hungary, the explanatory variabel lang.same is dropped
MF.RES<-NULL
lijst<-NULL
lijst1<-NULL

for(l in 1:nrow(landen)){
  #for(l in 1:2){
  land<-as.character(landen[l,1])
  MF.l<-MFB[MFB$CNTRY==land,]
  MF.res<-MF.l[,c("CNTRY","IDNO")]
  print(land)
  
  #####
  # standaardiseer alle targetvariabelen in array.t
  #####
  MF.l[,array.Bicc]<-lapply(MF.l[,array.Bicc],fun.st)
  #for(i in 1:2){
  for(i in 1:length(array.Bicc)){
    target<-array.Bicc[i]
    MF.s1<-MF.l[,c(target,"CNTRY","ID.IND","ID.INT","PSU","lft","sexe","opl2","LANG.SAME1","opl3","speedposB","dens","REGAT11","REGAT12", "REGAT13" ,     
                   "REGAT21"     ,   "REGAT22"      ,  "REGAT31"    ,    "REGAT32"   ,     "REGAT33"      ,  "REGAT34" ,      
                   "REGBE10",        "REGBE21"  ,      "REGBE22"  ,      "REGBE23",   "REGBE24"      ,  "REGBE25", "REGBE31" ,  
                   "REGBE32"   ,     "REGBE33"     ,   "REGBE34"    ,    "REGBE35"    ,    "REGCH01"   ,     "REGCH02"    ,    "REGCH03"       ,
                   "REGCHO5"   ,     "REGCH06"   ,     "REGCH07"    ,    "REGCH08"  ,      "REGDE1"  ,       "REGDE2"     ,    "REGDE3" ,       
                   "REGDE4"   ,      "REGDE5"   ,      "REGDE6"      ,   "REGDE7"    ,     "REGDE8"      ,   "REGDE9"    ,     "REGDEA"  ,      
                   "REGDEB" ,        "REGDEC"      ,   "REGDED"       ,  "REGDEE"    ,     "REGDEF"   ,      "REGDEG"   ,      "REGDK1" ,       
                   "REGDK2"  ,       "REGDK3"    ,     "REGDK4"  ,       "REGDK5"  ,       "REGEE01"  ,      "REGEE04"      ,  "REGEE06"   ,    
                   "REGEE07"      ,  "REGEE08"    ,    "REGFI193"     ,  "REGFI194"      , "REGFI195" ,      "REGFI196" ,      "REGFI197"  ,    
                   "REGFI1B1" ,      "REGFI1C1"  ,     "REGFI1C2" ,      "REGFI1C3"  ,     "REGFI1C4"    ,   "REGFI1C5"       ,"REGFI1D1",      
                   "REGFI1D2"  ,     "REGFI1D3"    ,   "REGFI1D4"  ,     "REGFI1D5"   ,    "REGFI1D6"  ,     "REGFI1D7"  ,     "REGFI200"  ,    
                   "REGFR10"     ,   "REGFR21"    ,    "REGFR22"    ,    "REGFR23",        "REGFR24"  ,      "REGFR25"  ,      "REGFR26",       
                   "REGFR30" ,       "REGFR41"   ,     "REGFR42"   ,     "REGFR43"  ,      "REGFR51" ,       "REGFR52"  ,      "REGFR53"     ,  
                   "REGFR61"     ,   "REGFR62"    ,    "REGFR63"   ,     "REGFR71"    ,    "REGFR72"    ,    "REGFR81"    ,    "REGFR82" ,      
                   "REGHU101"  ,     "REGHU102"  ,     "REGHU211"   ,    "REGHU212" ,      "REGHU213"     ,  "REGHU221"   ,    "REGHU222"  ,    
                   "REGHU223"  ,     "REGHU231"      , "REGHU232"  ,     "REGHU233"    ,   "REGHU311"   ,    "REGHU312"      , "REGHU313" ,     
                   "REGHU321"   ,    "REGHU322"   ,    "REGHU323"     ,  "REGHU331"   ,    "REGHU332"   ,    "REGHU333"   ,    "REGIE011"  ,    
                   "REGIE012"      , "REGIE013"   ,    "REGIE021"    ,   "REGIE022"    ,   "REGIE023"   ,    "REGIE024"   ,    "REGNL11"  ,     
                   "REGNL12"   ,     "REGNL13"    ,    "REGNL21"    ,    "REGNL22"    ,    "REGNL23"    ,    "REGNL31" ,       "REGNL32"   ,    
                   "REGNL33" ,       "REGNL34"     ,   "REGNL41"   ,     "REGNL42"   ,     "REGNO001" ,      "REGNO002"    ,   "REGNO003"  ,    
                   "REGNO004"    ,   "REGNO005"    ,   "REGNO006"   ,    "REGNO007"   ,    "REGSE110"  ,     "REGSE121" ,      "REGSE122"  ,    
                   "REGSE123"  ,     "REGSE124"     ,  "REGSE125"   ,    "REGSE211"   ,    "REGSE212" ,      "REGSE213"  ,     "REGSE214"  ,    
                   "REGSE221" ,      "REGSE224" ,      "REGSE231"   ,    "REGSE232"   ,    "REGSE311"   ,    "REGSE312"     ,  "REGSE313"  ,    
                   "REGSE321" ,      "REGSE322"     ,  "REGSE331",       "REGSE332"  ,     "REGSI011"     ,  "REGSI012"    ,   "REGSI013"  , 
                   "REGSI014"  ,     "REGSI015"  ,     "REGSI016"     ,  "REGSI017"  ,     "REGSI018"     ,  "REGSI021"       ,"REGSI022"  ,    
                   "REGSI023" ,      "REGSI024"    ,   "REGUKC" ,        "REGUKD"   ,      "REGUKE",         "REGUKF"   ,      "REGUKG"    ,    
                   "REGUKH"  ,       "REGUKI"        , "REGUKJ"   ,      "REGUKK"   ,      "REGUKL"      ,   "REGUKM"       ,  "REGUKN"  )]
    names(MF.s1)<-c("target","CNTRY","ID.IND","ID.INT","PSU","lft","sexe","opl2","LANG.SAME1","opl3","speedposB","dens","REGAT11","REGAT12", "REGAT13" ,     
                    "REGAT21"     ,   "REGAT22"      ,  "REGAT31"    ,    "REGAT32"   ,     "REGAT33"      ,  "REGAT34" ,      
                    "REGBE10",        "REGBE21"  ,      "REGBE22"  ,      "REGBE23",   "REGBE24"      ,  "REGBE25", "REGBE31" ,  
                    "REGBE32"   ,     "REGBE33"     ,   "REGBE34"    ,    "REGBE35"    ,    "REGCH01"   ,     "REGCH02"    ,    "REGCH03"       ,
                    "REGCHO5"   ,     "REGCH06"   ,     "REGCH07"    ,    "REGCH08"  ,      "REGDE1"  ,       "REGDE2"     ,    "REGDE3" ,       
                    "REGDE4"   ,      "REGDE5"   ,      "REGDE6"      ,   "REGDE7"    ,     "REGDE8"      ,   "REGDE9"    ,     "REGDEA"  ,      
                    "REGDEB" ,        "REGDEC"      ,   "REGDED"       ,  "REGDEE"    ,     "REGDEF"   ,      "REGDEG"   ,      "REGDK1" ,       
                    "REGDK2"  ,       "REGDK3"    ,     "REGDK4"  ,       "REGDK5"  ,       "REGEE01"  ,      "REGEE04"      ,  "REGEE06"   ,    
                    "REGEE07"      ,  "REGEE08"    ,    "REGFI193"     ,  "REGFI194"      , "REGFI195" ,      "REGFI196" ,      "REGFI197"  ,    
                    "REGFI1B1" ,      "REGFI1C1"  ,     "REGFI1C2" ,      "REGFI1C3"  ,     "REGFI1C4"    ,   "REGFI1C5"       ,"REGFI1D1",      
                    "REGFI1D2"  ,     "REGFI1D3"    ,   "REGFI1D4"  ,     "REGFI1D5"   ,    "REGFI1D6"  ,     "REGFI1D7"  ,     "REGFI200"  ,    
                    "REGFR10"     ,   "REGFR21"    ,    "REGFR22"    ,    "REGFR23",        "REGFR24"  ,      "REGFR25"  ,      "REGFR26",       
                    "REGFR30" ,       "REGFR41"   ,     "REGFR42"   ,     "REGFR43"  ,      "REGFR51" ,       "REGFR52"  ,      "REGFR53"     ,  
                    "REGFR61"     ,   "REGFR62"    ,    "REGFR63"   ,     "REGFR71"    ,    "REGFR72"    ,    "REGFR81"    ,    "REGFR82" ,      
                    "REGHU101"  ,     "REGHU102"  ,     "REGHU211"   ,    "REGHU212" ,      "REGHU213"     ,  "REGHU221"   ,    "REGHU222"  ,    
                    "REGHU223"  ,     "REGHU231"      , "REGHU232"  ,     "REGHU233"    ,   "REGHU311"   ,    "REGHU312"      , "REGHU313" ,     
                    "REGHU321"   ,    "REGHU322"   ,    "REGHU323"     ,  "REGHU331"   ,    "REGHU332"   ,    "REGHU333"   ,    "REGIE011"  ,    
                    "REGIE012"      , "REGIE013"   ,    "REGIE021"    ,   "REGIE022"    ,   "REGIE023"   ,    "REGIE024"   ,    "REGNL11"  ,     
                    "REGNL12"   ,     "REGNL13"    ,    "REGNL21"    ,    "REGNL22"    ,    "REGNL23"    ,    "REGNL31" ,       "REGNL32"   ,    
                    "REGNL33" ,       "REGNL34"     ,   "REGNL41"   ,     "REGNL42"   ,     "REGNO001" ,      "REGNO002"    ,   "REGNO003"  ,    
                    "REGNO004"    ,   "REGNO005"    ,   "REGNO006"   ,    "REGNO007"   ,    "REGSE110"  ,     "REGSE121" ,      "REGSE122"  ,    
                    "REGSE123"  ,     "REGSE124"     ,  "REGSE125"   ,    "REGSE211"   ,    "REGSE212" ,      "REGSE213"  ,     "REGSE214"  ,    
                    "REGSE221" ,      "REGSE224" ,      "REGSE231"   ,    "REGSE232"   ,    "REGSE311"   ,    "REGSE312"     ,  "REGSE313"  ,    
                    "REGSE321" ,      "REGSE322"     ,  "REGSE331",       "REGSE332"  ,     "REGSI011"     ,  "REGSI012"    ,   "REGSI013"  , 
                    "REGSI014"  ,     "REGSI015"  ,     "REGSI016"     ,  "REGSI017"  ,     "REGSI018"     ,  "REGSI021"       ,"REGSI022"  ,    
                    "REGSI023" ,      "REGSI024"    ,   "REGUKC" ,        "REGUKD"   ,      "REGUKE",         "REGUKF"   ,      "REGUKG"    ,    
                    "REGUKH"  ,       "REGUKI"        , "REGUKJ"   ,      "REGUKK"   ,      "REGUKL"      ,   "REGUKM"       ,  "REGUKN" )
    
    #####
    # Bereken per target variabele in elke land de residuelen van regressie met achtergrond var. als covariaten.
    #####
    
    
    for(speedposB in -1:1){
      MF.s2<-MF.s1[MF.s1$speedposB==speedposB,]
      
      #####
      # Bereken binnen elke groep van interviewers the var. componenten
      #####
      
      m1<-lmer(target~lft+sexe+opl2+opl3+LANG.SAME1+dens+
                 REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
                 REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
                 REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
                 REGDED+REGDEE+REGDEF+REGDEG+
                 REGDK2+REGDK3+REGDK4+REGDK5+
                 REGEE01+REGEE04++REGEE07+REGEE08+
                 REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
                 +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
                 REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
                 REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
                 REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
                 REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
                 REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
                 REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
                 REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
                 REGSI023+REGSI024
               +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN+(1|ID.INT),data=MF.s2)
      lijn1<-cbind(unlist(VarCorr(m1)),(attr(VarCorr(m1), "sc"))^2,speedposB)
      row.names(lijn1)<-paste(land,target)
      lijst1<-rbind(lijst1,lijn1)
    }
    
    
    
  }
  
}


lijst1<-as.data.frame(lijst1)
lijst1$target<-substr(row.names(lijst1),3,15)
lijst1$CNTRY<-substr(row.names(lijst1),1,2)

row.names(lijst1)<-NULL
names(lijst1)<-c("INT.var","ERR","speedposB","TARGET","CNTRY")
lijst1$prop.ERR<-lijst1$ERR/(lijst1$ERR+lijst1$INT.var)
lijst1$prop.INT.var<-lijst1$INT.var/(lijst1$ERR+lijst1$INT.var)
lijst1$ICC<-lijst1$prop.INT.var*100
lijst1$sGRB<-ifelse(lijst1$speedposB==-1,2,lijst1$speedposB)
lijst1$traag<-ifelse(lijst1$speedposB==-1,1,0)
lijst1$snel<-ifelse(lijst1$speedposB==1,1,0)
lijst1<-lijst1[order(lijst1$CNTRY,lijst1$sGRB),]



ICC2<-lmer(ICC~traag+snel+(0+traag+snel|CNTRY)+(1|TARGET),data=lijst1)
summary(ICC2)
rand(ICC2)

ICC1<-lmer(ICC~traag+snel+(traag+snel|CNTRY)+(1|TARGET),data=lijst1,REML=F)
summary(ICC1)
rand(ICC1)
anova(ICC1,ICC2)

b<-ranef(ICC1, condVar=TRUE)
rdeffectB<-as.data.frame(b[2])
targetB<-as.data.frame(b[1])
c<-as.data.frame(fixef(ICC1))

rdeffectB$expmoderat<-rdeffectB$CNTRY..Intercept+c[1,1]
rdeffectB$expsnel<-rdeffectB$CNTRY..Intercept+c[1,1]+rdeffectB$CNTRY.snel+c[3,1]
rdeffectB$exptraaf<-rdeffectB$CNTRY..Intercept+c[1,1]+rdeffectB$CNTRY.traag+c[2,1]




ICC2H<-lmer(ICC~traag+snel+(0+traag+snel|CNTRY)+(1|TARGET),data=lijst1[which(!lijst1$CNTRY=="HU"),])
summary(ICC2H)
rand(ICC2H)

ICC1H<-lmer(ICC~traag+snel+(traag+snel|CNTRY)+(1|TARGET),data=lijst1[which(!lijst1$CNTRY=="HU"),],REML=F)
summary(ICC1H)
rand(ICC1H)

anova(ICC1H,ICC2H)
lijst1$speedposB1<-ifelse(lijst1$speedposB==-1,"Slow",ifelse(lijst1$speedposB==1,"Fast","Mod."))

lijst1$CNTRYplot<-revalue(lijst1$CNTRY, c("AT"="Austria","BE"="Belgium","DK"="Denmark","EE"="Estonia","FI"="Finland"
                                  ,"FR"="France","HU"="Hungary","IE"="Ireland","DE"="Germany","NL"="The Netherlands","NO"="Norway"
                                  ,"SI"="Slovenia","SE"="Sweden","CH"="Switzerland","GB"="The UK"))

ICCBdifferences<-lijst1[,c("CNTRYplot","speedposB1", "TARGET", "ICC")] 
ICCBdifferences_wide<-ICCBdifferences %>% spread(speedposB1, ICC)
ICCBdifferences_wide$slow_moderate<- ICCBdifferences_wide$Slow-ICCBdifferences_wide$Mod.
ICCBdifferences_wide$fast_moderate<- ICCBdifferences_wide$Fast-ICCBdifferences_wide$Mod.
ICCBdifferences_long <- ICCBdifferences_wide[, c('CNTRYplot','TARGET','slow_moderate', 'fast_moderate')] %>% gather(slow_fast, ICC_differences, -CNTRYplot, -TARGET)
ICCBdifferences_mean <-ICCBdifferences_wide %>% group_by(CNTRYplot)%>% summarise(meanSM=mean(slow_moderate,na.rm=T),
                                                                                    sdSM=sd(slow_moderae,na.rm=T),
                                                                                    meanFM=mean(fast_moderate,na.rm=T),
                                                                                    sdFM=sd(fast_moderate, na.rm=T))
ICCBmean<-lijst1 %>% group_by(CNTRYplot,speedposB1)%>% summarise(meanICC=mean(ICC,na.rm=T),
                                                                 sdICC=sd(ICC,na.rm=T))


ICCBdifferences_long <- ICCBdifferences_wide[, c('CNTRYplot','TARGET','slow_moderate', 'fast_moderate')] %>% gather(slow_fast, ICC_differences, -CNTRYplot, -TARGET)
ggplot(data=ICCBdifferences_long,aes(x = CNTRYplot, y = ICC_differences, fill = slow_fast)) +      
  geom_boxplot() +
# stat_summary(fun.y=mean, colour="darkred", geom="point", 
#              shape=18, size=3,show_guide = FALSE) + 
 labs(x="Countries",y="Difference in ICC") +
 theme(legend.position = c(0.9, 0.6))+ guides(fill=guide_legend(title=NULL)) +
 scale_fill_discrete(name=" ", breaks=c("fast_moderate", "slow_moderate"), labels=c("Fast vs moderate", "Slow vs moderate")) +
 theme(axis.text.x = element_text(angle=60, hjust=1))





####
# module C
#####

MF.RES<-NULL
lijst<-NULL
lijst1<-NULL
for(l in 1:nrow(landen)){
  land<-as.character(landen[l,1])
  MF.l<-MFC[MFC$CNTRY==land,]
  MF.res<-MF.l[,c("CNTRY","IDNO")]
  print(land)
  
  #####
  # standaardiseer alle targetvariabelen in array.t
  #####
  MF.l[,array.Cicc]<-lapply(MF.l[,array.Cicc],fun.st)
  #for(i in 1:2){
  for(i in 1:length(array.Cicc)){
    target<-array.Cicc[i]
    MF.s1<-MF.l[,c(target,"CNTRY","ID.IND","ID.INT","lft","sexe","opl2","LANG.SAME1","opl3","speedposC","dens","REGAT11","REGAT12", "REGAT13" ,     
                   "REGAT21"     ,   "REGAT22"      ,  "REGAT31"    ,    "REGAT32"   ,     "REGAT33"      ,  "REGAT34" ,      
                   "REGBE10",        "REGBE21"  ,      "REGBE22"  ,      "REGBE23",   "REGBE24"      ,  "REGBE25", "REGBE31" ,  
                   "REGBE32"   ,     "REGBE33"     ,   "REGBE34"    ,    "REGBE35"    ,    "REGCH01"   ,     "REGCH02"    ,    "REGCH03"       ,
                   "REGCHO5"   ,     "REGCH06"   ,     "REGCH07"    ,    "REGCH08"  ,      "REGDE1"  ,       "REGDE2"     ,    "REGDE3" ,       
                   "REGDE4"   ,      "REGDE5"   ,      "REGDE6"      ,   "REGDE7"    ,     "REGDE8"      ,   "REGDE9"    ,     "REGDEA"  ,      
                   "REGDEB" ,        "REGDEC"      ,   "REGDED"       ,  "REGDEE"    ,     "REGDEF"   ,      "REGDEG"   ,      "REGDK1" ,       
                   "REGDK2"  ,       "REGDK3"    ,     "REGDK4"  ,       "REGDK5"  ,       "REGEE01"  ,      "REGEE04"      ,  "REGEE06"   ,    
                   "REGEE07"      ,  "REGEE08"    ,    "REGFI193"     ,  "REGFI194"      , "REGFI195" ,      "REGFI196" ,      "REGFI197"  ,    
                   "REGFI1B1" ,      "REGFI1C1"  ,     "REGFI1C2" ,      "REGFI1C3"  ,     "REGFI1C4"    ,   "REGFI1C5"       ,"REGFI1D1",      
                   "REGFI1D2"  ,     "REGFI1D3"    ,   "REGFI1D4"  ,     "REGFI1D5"   ,    "REGFI1D6"  ,     "REGFI1D7"  ,     "REGFI200"  ,    
                   "REGFR10"     ,   "REGFR21"    ,    "REGFR22"    ,    "REGFR23",        "REGFR24"  ,      "REGFR25"  ,      "REGFR26",       
                   "REGFR30" ,       "REGFR41"   ,     "REGFR42"   ,     "REGFR43"  ,      "REGFR51" ,       "REGFR52"  ,      "REGFR53"     ,  
                   "REGFR61"     ,   "REGFR62"    ,    "REGFR63"   ,     "REGFR71"    ,    "REGFR72"    ,    "REGFR81"    ,    "REGFR82" ,      
                   "REGHU101"  ,     "REGHU102"  ,     "REGHU211"   ,    "REGHU212" ,      "REGHU213"     ,  "REGHU221"   ,    "REGHU222"  ,    
                   "REGHU223"  ,     "REGHU231"      , "REGHU232"  ,     "REGHU233"    ,   "REGHU311"   ,    "REGHU312"      , "REGHU313" ,     
                   "REGHU321"   ,    "REGHU322"   ,    "REGHU323"     ,  "REGHU331"   ,    "REGHU332"   ,    "REGHU333"   ,    "REGIE011"  ,    
                   "REGIE012"      , "REGIE013"   ,    "REGIE021"    ,   "REGIE022"    ,   "REGIE023"   ,    "REGIE024"   ,    "REGNL11"  ,     
                   "REGNL12"   ,     "REGNL13"    ,    "REGNL21"    ,    "REGNL22"    ,    "REGNL23"    ,    "REGNL31" ,       "REGNL32"   ,    
                   "REGNL33" ,       "REGNL34"     ,   "REGNL41"   ,     "REGNL42"   ,     "REGNO001" ,      "REGNO002"    ,   "REGNO003"  ,    
                   "REGNO004"    ,   "REGNO005"    ,   "REGNO006"   ,    "REGNO007"   ,    "REGSE110"  ,     "REGSE121" ,      "REGSE122"  ,    
                   "REGSE123"  ,     "REGSE124"     ,  "REGSE125"   ,    "REGSE211"   ,    "REGSE212" ,      "REGSE213"  ,     "REGSE214"  ,    
                   "REGSE221" ,      "REGSE224" ,      "REGSE231"   ,    "REGSE232"   ,    "REGSE311"   ,    "REGSE312"     ,  "REGSE313"  ,    
                   "REGSE321" ,      "REGSE322"     ,  "REGSE331",       "REGSE332"  ,     "REGSI011"     ,  "REGSI012"    ,   "REGSI013"  , 
                   "REGSI014"  ,     "REGSI015"  ,     "REGSI016"     ,  "REGSI017"  ,     "REGSI018"     ,  "REGSI021"       ,"REGSI022"  ,    
                   "REGSI023" ,      "REGSI024"    ,   "REGUKC" ,        "REGUKD"   ,      "REGUKE",         "REGUKF"   ,      "REGUKG"    ,    
                   "REGUKH"  ,       "REGUKI"        , "REGUKJ"   ,      "REGUKK"   ,      "REGUKL"      ,   "REGUKM",   "REGUKN" )]
    names(MF.s1)<-c("target","CNTRY","ID.IND","ID.INT","lft","sexe","opl2","LANG.SAME1","opl3","speedposC","dens","REGAT11","REGAT12", "REGAT13" ,     
                    "REGAT21"     ,   "REGAT22"      ,  "REGAT31"    ,    "REGAT32"   ,     "REGAT33"      ,  "REGAT34" ,      
                    "REGBE10",        "REGBE21"  ,      "REGBE22"  ,      "REGBE23",   "REGBE24"      ,  "REGBE25", "REGBE31" ,  
                    "REGBE32"   ,     "REGBE33"     ,   "REGBE34"    ,    "REGBE35"    ,    "REGCH01"   ,     "REGCH02"    ,    "REGCH03"       ,
                    "REGCHO5"   ,     "REGCH06"   ,     "REGCH07"    ,    "REGCH08"  ,      "REGDE1"  ,       "REGDE2"     ,    "REGDE3" ,       
                    "REGDE4"   ,      "REGDE5"   ,      "REGDE6"      ,   "REGDE7"    ,     "REGDE8"      ,   "REGDE9"    ,     "REGDEA"  ,      
                    "REGDEB" ,        "REGDEC"      ,   "REGDED"       ,  "REGDEE"    ,     "REGDEF"   ,      "REGDEG"   ,      "REGDK1" ,       
                    "REGDK2"  ,       "REGDK3"    ,     "REGDK4"  ,       "REGDK5"  ,       "REGEE01"  ,      "REGEE04"      ,  "REGEE06"   ,    
                    "REGEE07"      ,  "REGEE08"    ,    "REGFI193"     ,  "REGFI194"      , "REGFI195" ,      "REGFI196" ,      "REGFI197"  ,    
                    "REGFI1B1" ,      "REGFI1C1"  ,     "REGFI1C2" ,      "REGFI1C3"  ,     "REGFI1C4"    ,   "REGFI1C5"       ,"REGFI1D1",      
                    "REGFI1D2"  ,     "REGFI1D3"    ,   "REGFI1D4"  ,     "REGFI1D5"   ,    "REGFI1D6"  ,     "REGFI1D7"  ,     "REGFI200"  ,    
                    "REGFR10"     ,   "REGFR21"    ,    "REGFR22"    ,    "REGFR23",        "REGFR24"  ,      "REGFR25"  ,      "REGFR26",       
                    "REGFR30" ,       "REGFR41"   ,     "REGFR42"   ,     "REGFR43"  ,      "REGFR51" ,       "REGFR52"  ,      "REGFR53"     ,  
                    "REGFR61"     ,   "REGFR62"    ,    "REGFR63"   ,     "REGFR71"    ,    "REGFR72"    ,    "REGFR81"    ,    "REGFR82" ,      
                    "REGHU101"  ,     "REGHU102"  ,     "REGHU211"   ,    "REGHU212" ,      "REGHU213"     ,  "REGHU221"   ,    "REGHU222"  ,    
                    "REGHU223"  ,     "REGHU231"      , "REGHU232"  ,     "REGHU233"    ,   "REGHU311"   ,    "REGHU312"      , "REGHU313" ,     
                    "REGHU321"   ,    "REGHU322"   ,    "REGHU323"     ,  "REGHU331"   ,    "REGHU332"   ,    "REGHU333"   ,    "REGIE011"  ,    
                    "REGIE012"      , "REGIE013"   ,    "REGIE021"    ,   "REGIE022"    ,   "REGIE023"   ,    "REGIE024"   ,    "REGNL11"  ,     
                    "REGNL12"   ,     "REGNL13"    ,    "REGNL21"    ,    "REGNL22"    ,    "REGNL23"    ,    "REGNL31" ,       "REGNL32"   ,    
                    "REGNL33" ,       "REGNL34"     ,   "REGNL41"   ,     "REGNL42"   ,     "REGNO001" ,      "REGNO002"    ,   "REGNO003"  ,    
                    "REGNO004"    ,   "REGNO005"    ,   "REGNO006"   ,    "REGNO007"   ,    "REGSE110"  ,     "REGSE121" ,      "REGSE122"  ,    
                    "REGSE123"  ,     "REGSE124"     ,  "REGSE125"   ,    "REGSE211"   ,    "REGSE212" ,      "REGSE213"  ,     "REGSE214"  ,    
                    "REGSE221" ,      "REGSE224" ,      "REGSE231"   ,    "REGSE232"   ,    "REGSE311"   ,    "REGSE312"     ,  "REGSE313"  ,    
                    "REGSE321" ,      "REGSE322"     ,  "REGSE331",       "REGSE332"  ,     "REGSI011"     ,  "REGSI012"    ,   "REGSI013"  , 
                    "REGSI014"  ,     "REGSI015"  ,     "REGSI016"     ,  "REGSI017"  ,     "REGSI018"     ,  "REGSI021"       ,"REGSI022"  ,    
                    "REGSI023" ,      "REGSI024"    ,   "REGUKC" ,        "REGUKD"   ,      "REGUKE",         "REGUKF"   ,      "REGUKG"    ,    
                    "REGUKH"  ,       "REGUKI"        , "REGUKJ"   ,      "REGUKK"   ,      "REGUKL"      ,   "REGUKM",    "REGUKN")
    
    #####
    # Bereken per target variabele in elke land de residuelen van regressie met achtergrond var. als covariaten.
    #####
    
   
    
    
    for(speedposC in -1:1){
      MF.s2<-MF.s1[MF.s1$speedposC==speedposC,]
      
      #####
      # Bereken binnen elke groep van interviewers the var. componenten
      #####
      
      m1<-lmer(target~lft+sexe+opl2+opl3+LANG.SAME1+dens+
                 REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
                 REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
                 REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
                 REGDED+REGDEE+REGDEF+REGDEG+
                 REGDK2+REGDK3+REGDK4+REGDK5+
                 REGEE01+REGEE04++REGEE07+REGEE08+
                 REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
                 +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
                 REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
                 REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
                 REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
                 REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
                 REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
                 REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
                 REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
                 REGSI023+REGSI024
               +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN+(1|ID.INT),data=MF.s2)
      lijn1<-cbind(unlist(VarCorr(m1)),(attr(VarCorr(m1), "sc"))^2,speedposC)
      row.names(lijn1)<-paste(land,target)
      lijst1<-rbind(lijst1,lijn1)
    }
    
  }
  
}



lijst1<-as.data.frame(lijst1)
lijst1$target<-substr(row.names(lijst1),3,15)
lijst1$CNTRY<-substr(row.names(lijst1),1,2)

row.names(lijst1)<-NULL
names(lijst1)<-c("INT.var","ERR","speedposC","TARGET","CNTRY")
lijst1$prop.ERR<-lijst1$ERR/(lijst1$ERR+lijst1$INT.var)
lijst1$prop.INT.var<-lijst1$INT.var/(lijst1$ERR+lijst1$INT.var)
lijst1$ICC<-lijst1$prop.INT.var*100
lijst1$sGRC<-ifelse(lijst1$speedposC==-1,2,lijst1$speedposC)

lijst1$traag<-ifelse(lijst1$speedposC==-1,1,0)
lijst1$snel<-ifelse(lijst1$speedposC==1,1,0)
lijst1<-lijst1[order(lijst1$CNTRY,lijst1$sGRC),]



ICC2<-lmer(ICC~traag+snel+(0+traag+snel|CNTRY)+(1|TARGET),data=lijst1)
summary(ICC2)
rand(ICC2)

ICC1<-lmer(ICC~traag+snel+(traag+snel|CNTRY)+(1|TARGET),data=lijst1,REML=F)
summary(ICC1)
rand(ICC1)
anova(ICC1,ICC2)

b<-ranef(ICC1, condVar=TRUE)
rdeffectC<-as.data.frame(b[1])
targetC<-as.data.frame(b[2])
c<-as.data.frame(fixef(ICC1))

rdeffectC$expmoderatC<-rdeffectC$CNTRY..Intercept+c[1,1]
rdeffectC$expsnelC<-rdeffectC$CNTRY..Intercept+c[1,1]+rdeffectC$CNTRY.snel+c[3,1]
rdeffectC$exptraafC<-rdeffectC$CNTRY..Intercept+c[1,1]+rdeffectC$CNTRY.traag+c[2,1]






ICC2<-lmer(ICC~traag+snel+(0+traag+snel|CNTRY)+(1|TARGET),data=lijst1[which(!lijst1$CNTRY=="HU"),],REML=F)
summary(ICC2)
rand(ICC2)

ICC1<-lmer(ICC~traag+snel+(traag+snel|CNTRY)+(1|TARGET),data=lijst1[which(!lijst1$CNTRY=="HU"),],REML=F)
summary(ICC1)
rand(ICC1)

anova(ICC1,ICC2)

lijst1$CNTRYplot<-revalue(lijst1$CNTRY, c("AT"="Austria","BE"="Belgium","DK"="Denmark","EE"="Estonia","FI"="Finland"
                                          ,"FR"="France","HU"="Hungary","IE"="Ireland","DE"="Germany","NL"="The Netherlands","NO"="Norway"
                                          ,"SI"="Slovenia","SE"="Sweden","CH"="Switzerland","GB"="The UK"))
lijst1$speedposC1<-ifelse(lijst1$speedposC==-1,"Slow",ifelse(lijst1$speedposC==1,"Fast","Mod."))


ICCCmean<-lijst1 %>% group_by(CNTRYplot,speedposC1)%>% summarise(meanICC=mean(ICC,na.rm=T),
                                                                           sdICC=sd(ICC,na.rm=T))

ICCCdifferences<-lijst1[,c("CNTRYplot","speedposC1", "TARGET", "ICC")] 
ICCCdifferences_wide<-ICCCdifferences %>% spread(speedposC1, ICC)
ICCCdifferences_wide$slow_moderate<- ICCCdifferences_wide$Slow-ICCCdifferences_wide$Mod.
ICCCdifferences_wide$fast_moderate<- ICCCdifferences_wide$Fast-ICCCdifferences_wide$Mod.
ICCCdifferences_mean <-ICCCdifferences_wide %>% group_by(CNTRYplot)%>% summarise(meanSM=mean(slow_moderate,na.rm=T),
                                                                                 sdSM=sd(slow_moderate,na.rm=T),
                                                                                 meanFM=mean(fast_moderate,na.rm=T),
                                                                                 sdFM=sd(fast_moderate, na.rm=T))

ICCCdifferences_long <- ICCCdifferences_wide[, c('CNTRYplot','TARGET','slow_moderate', 'fast_moderate')] %>% gather(slow_fast, ICC_differences, -CNTRYplot, -TARGET)
ggplot(data=ICCCdifferences_long,aes(x = CNTRYplot, y = ICC_differences, fill = slow_fast)) +      
  geom_boxplot() +
  # stat_summary(fun.y=mean, colour="darkred", geom="point", 
  #              shape=18, size=3,show_guide = FALSE) + 
  labs(x="Countries",y="Difference in ICC") +
  theme(legend.position = c(0.9, 0.9))+ guides(fill=guide_legend(title=NULL)) +
  scale_fill_discrete(name=" ", breaks=c("fast_moderate", "slow_moderate"), labels=c("Fast vs moderate", "Slow vs moderate")) +
  theme(axis.text.x = element_text(angle=60, hjust=1))

#ggplot(data=lijst1,aes(x=factor(speedposC1),y=prop.INT.var))+
#  geom_boxplot()+
#  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("Figure 1.2: Interviewer effects per interview style in Module C")+
# labs(x="Interview type",y="Interviewer effect")+
# scale_y_continuous(limits = c(0, 0.5)) +stat_summary(fun.y=mean, colour="darkred", geom="point", 
#                                                   shape=18, size=3,show_guide = FALSE) 
#


####
# module D
#####

MF.RES<-NULL
lijst<-NULL
lijst1<-NULL
for(l in 1:nrow(landen)){
  land<-as.character(landen[l,1])
  MF.l<-MFD[MFD$CNTRY==land,]
  MF.res<-MF.l[,c("CNTRY","IDNO")]
  print(land)
  
  #####
  # standaardiseer alle targetvariabelen in array.t
  #####
  MF.l[,array.Dicc]<-lapply(MF.l[,array.Dicc],fun.st)
  #for(i in 1:2){
  for(i in 1:length(array.Dicc)){
    target<-array.Dicc[i]
    MF.s1<-MF.l[,c(target,"CNTRY","ID.IND","ID.INT","lft","sexe","opl2","LANG.SAME1","opl3","speedposD","dens","REGAT11","REGAT12", "REGAT13" ,     
                   "REGAT21"     ,   "REGAT22"      ,  "REGAT31"    ,    "REGAT32"   ,     "REGAT33"      ,  "REGAT34" ,      
                   "REGBE10",        "REGBE21"  ,      "REGBE22"  ,      "REGBE23",   "REGBE24"      ,  "REGBE25", "REGBE31" ,  
                   "REGBE32"   ,     "REGBE33"     ,   "REGBE34"    ,    "REGBE35"    ,    "REGCH01"   ,     "REGCH02"    ,    "REGCH03"       ,
                   "REGCHO5"   ,     "REGCH06"   ,     "REGCH07"    ,    "REGCH08"  ,      "REGDE1"  ,       "REGDE2"     ,    "REGDE3" ,       
                   "REGDE4"   ,      "REGDE5"   ,      "REGDE6"      ,   "REGDE7"    ,     "REGDE8"      ,   "REGDE9"    ,     "REGDEA"  ,      
                   "REGDEB" ,        "REGDEC"      ,   "REGDED"       ,  "REGDEE"    ,     "REGDEF"   ,      "REGDEG"   ,      "REGDK1" ,       
                   "REGDK2"  ,       "REGDK3"    ,     "REGDK4"  ,       "REGDK5"  ,       "REGEE01"  ,      "REGEE04"      ,  "REGEE06"   ,    
                   "REGEE07"      ,  "REGEE08"    ,    "REGFI193"     ,  "REGFI194"      , "REGFI195" ,      "REGFI196" ,      "REGFI197"  ,    
                   "REGFI1B1" ,      "REGFI1C1"  ,     "REGFI1C2" ,      "REGFI1C3"  ,     "REGFI1C4"    ,   "REGFI1C5"       ,"REGFI1D1",      
                   "REGFI1D2"  ,     "REGFI1D3"    ,   "REGFI1D4"  ,     "REGFI1D5"   ,    "REGFI1D6"  ,     "REGFI1D7"  ,     "REGFI200"  ,    
                   "REGFR10"     ,   "REGFR21"    ,    "REGFR22"    ,    "REGFR23",        "REGFR24"  ,      "REGFR25"  ,      "REGFR26",       
                   "REGFR30" ,       "REGFR41"   ,     "REGFR42"   ,     "REGFR43"  ,      "REGFR51" ,       "REGFR52"  ,      "REGFR53"     ,  
                   "REGFR61"     ,   "REGFR62"    ,    "REGFR63"   ,     "REGFR71"    ,    "REGFR72"    ,    "REGFR81"    ,    "REGFR82" ,      
                   "REGHU101"  ,     "REGHU102"  ,     "REGHU211"   ,    "REGHU212" ,      "REGHU213"     ,  "REGHU221"   ,    "REGHU222"  ,    
                   "REGHU223"  ,     "REGHU231"      , "REGHU232"  ,     "REGHU233"    ,   "REGHU311"   ,    "REGHU312"      , "REGHU313" ,     
                   "REGHU321"   ,    "REGHU322"   ,    "REGHU323"     ,  "REGHU331"   ,    "REGHU332"   ,    "REGHU333"   ,    "REGIE011"  ,    
                   "REGIE012"      , "REGIE013"   ,    "REGIE021"    ,   "REGIE022"    ,   "REGIE023"   ,    "REGIE024"   ,    "REGNL11"  ,     
                   "REGNL12"   ,     "REGNL13"    ,    "REGNL21"    ,    "REGNL22"    ,    "REGNL23"    ,    "REGNL31" ,       "REGNL32"   ,    
                   "REGNL33" ,       "REGNL34"     ,   "REGNL41"   ,     "REGNL42"   ,     "REGNO001" ,      "REGNO002"    ,   "REGNO003"  ,    
                   "REGNO004"    ,   "REGNO005"    ,   "REGNO006"   ,    "REGNO007"   ,    "REGSE110"  ,     "REGSE121" ,      "REGSE122"  ,    
                   "REGSE123"  ,     "REGSE124"     ,  "REGSE125"   ,    "REGSE211"   ,    "REGSE212" ,      "REGSE213"  ,     "REGSE214"  ,    
                   "REGSE221" ,      "REGSE224" ,      "REGSE231"   ,    "REGSE232"   ,    "REGSE311"   ,    "REGSE312"     ,  "REGSE313"  ,    
                   "REGSE321" ,      "REGSE322"     ,  "REGSE331",       "REGSE332"  ,     "REGSI011"     ,  "REGSI012"    ,   "REGSI013"  , 
                   "REGSI014"  ,     "REGSI015"  ,     "REGSI016"     ,  "REGSI017"  ,     "REGSI018"     ,  "REGSI021"       ,"REGSI022"  ,    
                   "REGSI023" ,      "REGSI024"    ,   "REGUKC" ,        "REGUKD"   ,      "REGUKE",         "REGUKF"   ,      "REGUKG"    ,    
                   "REGUKH"  ,       "REGUKI"        , "REGUKJ"   ,      "REGUKK"   ,      "REGUKL"      ,   "REGUKM",   "REGUKN")]
    names(MF.s1)<-c("target","CNTRY","ID.IND","ID.INT","lft","sexe","opl2","LANG.SAME1","opl3","speedposD","dens","REGAT11","REGAT12", "REGAT13" ,     
                    "REGAT21"     ,   "REGAT22"      ,  "REGAT31"    ,    "REGAT32"   ,     "REGAT33"      ,  "REGAT34" ,      
                    "REGBE10",        "REGBE21"  ,      "REGBE22"  ,      "REGBE23",   "REGBE24"      ,  "REGBE25", "REGBE31" ,  
                    "REGBE32"   ,     "REGBE33"     ,   "REGBE34"    ,    "REGBE35"    ,    "REGCH01"   ,     "REGCH02"    ,    "REGCH03"       ,
                    "REGCHO5"   ,     "REGCH06"   ,     "REGCH07"    ,    "REGCH08"  ,      "REGDE1"  ,       "REGDE2"     ,    "REGDE3" ,       
                    "REGDE4"   ,      "REGDE5"   ,      "REGDE6"      ,   "REGDE7"    ,     "REGDE8"      ,   "REGDE9"    ,     "REGDEA"  ,      
                    "REGDEB" ,        "REGDEC"      ,   "REGDED"       ,  "REGDEE"    ,     "REGDEF"   ,      "REGDEG"   ,      "REGDK1" ,       
                    "REGDK2"  ,       "REGDK3"    ,     "REGDK4"  ,       "REGDK5"  ,       "REGEE01"  ,      "REGEE04"      ,  "REGEE06"   ,    
                    "REGEE07"      ,  "REGEE08"    ,    "REGFI193"     ,  "REGFI194"      , "REGFI195" ,      "REGFI196" ,      "REGFI197"  ,    
                    "REGFI1B1" ,      "REGFI1C1"  ,     "REGFI1C2" ,      "REGFI1C3"  ,     "REGFI1C4"    ,   "REGFI1C5"       ,"REGFI1D1",      
                    "REGFI1D2"  ,     "REGFI1D3"    ,   "REGFI1D4"  ,     "REGFI1D5"   ,    "REGFI1D6"  ,     "REGFI1D7"  ,     "REGFI200"  ,    
                    "REGFR10"     ,   "REGFR21"    ,    "REGFR22"    ,    "REGFR23",        "REGFR24"  ,      "REGFR25"  ,      "REGFR26",       
                    "REGFR30" ,       "REGFR41"   ,     "REGFR42"   ,     "REGFR43"  ,      "REGFR51" ,       "REGFR52"  ,      "REGFR53"     ,  
                    "REGFR61"     ,   "REGFR62"    ,    "REGFR63"   ,     "REGFR71"    ,    "REGFR72"    ,    "REGFR81"    ,    "REGFR82" ,      
                    "REGHU101"  ,     "REGHU102"  ,     "REGHU211"   ,    "REGHU212" ,      "REGHU213"     ,  "REGHU221"   ,    "REGHU222"  ,    
                    "REGHU223"  ,     "REGHU231"      , "REGHU232"  ,     "REGHU233"    ,   "REGHU311"   ,    "REGHU312"      , "REGHU313" ,     
                    "REGHU321"   ,    "REGHU322"   ,    "REGHU323"     ,  "REGHU331"   ,    "REGHU332"   ,    "REGHU333"   ,    "REGIE011"  ,    
                    "REGIE012"      , "REGIE013"   ,    "REGIE021"    ,   "REGIE022"    ,   "REGIE023"   ,    "REGIE024"   ,    "REGNL11"  ,     
                    "REGNL12"   ,     "REGNL13"    ,    "REGNL21"    ,    "REGNL22"    ,    "REGNL23"    ,    "REGNL31" ,       "REGNL32"   ,    
                    "REGNL33" ,       "REGNL34"     ,   "REGNL41"   ,     "REGNL42"   ,     "REGNO001" ,      "REGNO002"    ,   "REGNO003"  ,    
                    "REGNO004"    ,   "REGNO005"    ,   "REGNO006"   ,    "REGNO007"   ,    "REGSE110"  ,     "REGSE121" ,      "REGSE122"  ,    
                    "REGSE123"  ,     "REGSE124"     ,  "REGSE125"   ,    "REGSE211"   ,    "REGSE212" ,      "REGSE213"  ,     "REGSE214"  ,    
                    "REGSE221" ,      "REGSE224" ,      "REGSE231"   ,    "REGSE232"   ,    "REGSE311"   ,    "REGSE312"     ,  "REGSE313"  ,    
                    "REGSE321" ,      "REGSE322"     ,  "REGSE331",       "REGSE332"  ,     "REGSI011"     ,  "REGSI012"    ,   "REGSI013"  , 
                    "REGSI014"  ,     "REGSI015"  ,     "REGSI016"     ,  "REGSI017"  ,     "REGSI018"     ,  "REGSI021"       ,"REGSI022"  ,    
                    "REGSI023" ,      "REGSI024"    ,   "REGUKC" ,        "REGUKD"   ,      "REGUKE",         "REGUKF"   ,      "REGUKG"    ,    
                    "REGUKH"  ,       "REGUKI"        , "REGUKJ"   ,      "REGUKK"   ,      "REGUKL"      ,   "REGUKM",   "REGUKN")
    
    #####
    # Bereken per target variabele in elke land de residuelen van regressie met achtergrond var. als covariaten.
    #####
    
    
    
    
    for(speedposD in -1:1){
      MF.s2<-MF.s1[MF.s1$speedposD==speedposD,]
      
      #####
      # Bereken binnen elke groep van interviewers the var. componenten
      #####
      
      m1<-lmer(target~lft+sexe+opl2+opl3+LANG.SAME1++dens+
                 REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
                 REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
                 REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
                 REGDED+REGDEE+REGDEF+REGDEG+
                 REGDK2+REGDK3+REGDK4+REGDK5+
                 REGEE01+REGEE04++REGEE07+REGEE08+
                 REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
                 +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
                 REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
                 REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
                 REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
                 REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
                 REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
                 REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
                 REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
                 REGSI023+REGSI024
               +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN+(1|ID.INT),data=MF.s2)
      lijn1<-cbind(unlist(VarCorr(m1)),(attr(VarCorr(m1), "sc"))^2,speedposD)
      row.names(lijn1)<-paste(land,target)
      lijst1<-rbind(lijst1,lijn1)
    }
    
  }
  
}



lijst1<-as.data.frame(lijst1)
lijst1$target<-substr(row.names(lijst1),3,15)
lijst1$CNTRY<-substr(row.names(lijst1),1,2)

row.names(lijst1)<-NULL
names(lijst1)<-c("INT.var","ERR","speedposD","TARGET","CNTRY")
lijst1$prop.ERR<-lijst1$ERR/(lijst1$ERR+lijst1$INT.var)
lijst1$prop.INT.var<-lijst1$INT.var/(lijst1$ERR+lijst1$INT.var)
lijst1$ICC<-lijst1$prop.INT.var*100
lijst1$sGRB<-ifelse(lijst1$speedposD==-1,2,lijst1$speedposD)

lijst1$traag<-ifelse(lijst1$speedposD==-1,1,0)
lijst1$snel<-ifelse(lijst1$speedposD==1,1,0)
lijst1<-lijst1[order(lijst1$CNTRY,lijst1$sGRB),]



ICC2<-lmer(ICC~traag+snel+(0+traag+snel|CNTRY)+(1|TARGET),data=lijst1)
summary(ICC2)
rand(ICC2)

ICC1<-lmer(ICC~traag+snel+(traag+snel|CNTRY)+(1|TARGET),data=lijst1,REML=F)
summary(ICC1)
rand(ICC1)
b<-ranef(ICC1, condVar=TRUE)
rdeffectD<-as.data.frame(b[1])
c<-as.data.frame(fixef(ICC1))
rdeffectD$expmoderatD<-rdeffectD$CNTRY..Intercept+c[1,1]
rdeffectD$expsnelD<-rdeffectD$CNTRY..Intercept+c[1,1]+rdeffectD$CNTRY.snel+c[3,1]
rdeffectD$exptraafD<-rdeffectD$CNTRY..Intercept+c[1,1]+rdeffectD$CNTRY.traag+c[2,1]

anova(ICC1,ICC2)

ICC2<-lmer(ICC~traag+snel+(0+traag+snel|CNTRY)+(1|TARGET),data=lijst1[which(!lijst1$CNTRY=="HU"),],REML=F)
summary(ICC2)
rand(ICC2)

ICC1<-lmer(ICC~traag+snel+(traag+snel|CNTRY)+(1|TARGET),data=lijst1[which(!lijst1$CNTRY=="HU"),],REML=F)
summary(ICC1)
rand(ICC1)

anova(ICC1,ICC2)


lijst1$CNTRYplot<-revalue(lijst1$CNTRY, c("AT"="Austria","BE"="Belgium","DK"="Denmark","EE"="Estonia","FI"="Finland"
                                          ,"FR"="France","HU"="Hungary","IE"="Ireland","DE"="Germany","NL"="The Netherlands","NO"="Norway"
                                          ,"SI"="Slovenia","SE"="Sweden","CH"="Switzerland","GB"="The UK"))
lijst1$speedposD1<-ifelse(lijst1$speedposD==-1,"Slow",ifelse(lijst1$speedposD==1,"Fast","Mod."))

ICCDmean<-lijst1 %>% group_by(CNTRYplot,speedposD1)%>% summarise(meanICC=mean(ICC,na.rm=T),
                                                                 sdICC=sd(ICC,na.rm=T))

ICCDdifferences<-lijst1[,c("CNTRYplot","speedposD1", "TARGET", "ICC")] 
ICCDdifferences_wide<-ICCDdifferences %>% spread(speedposD1, ICC)
ICCDdifferences_wide$slow_moderate<- ICCDdifferences_wide$Slow-ICCDdifferences_wide$Mod.
ICCDdifferences_wide$fast_moderate<- ICCDdifferences_wide$Fast-ICCDdifferences_wide$Mod.
ICCDdifferences_mean <-ICCDdifferences_wide %>% group_by(CNTRYplot)%>% summarise(meanSM=mean(slow_moderate,na.rm=T),
                                                                                 sdSM=sd(slow_moderate,na.rm=T),
                                                                                 meanFM=mean(fast_moderate,na.rm=T),
                                                                                 sdFM=sd(fast_moderate, na.rm=T))


ICCDdifferences_long <- ICCDdifferences_wide[, c('CNTRYplot','TARGET','slow_moderate', 'fast_moderate')] %>% gather(slow_fast, ICC_differences, -CNTRYplot, -TARGET)
ggplot(data=ICCDdifferences_long,aes(x = CNTRYplot, y = ICC_differences, fill = slow_fast)) +      
  geom_boxplot() +
  # stat_summary(fun.y=mean, colour="darkred", geom="point", 
  #              shape=18, size=3,show_guide = FALSE) + 
  labs(x="Countries",y="Difference in ICC") +
  theme(legend.position = c(0.9, 0.9))+ guides(fill=guide_legend(title=NULL)) +
  scale_fill_discrete(name=" ", breaks=c("fast_moderate", "slow_moderate"), labels=c("Fast vs moderate", "Slow vs moderate")) +
  theme(axis.text.x = element_text(angle=60, hjust=1))
#ggplot(data=lijst1,aes(x=factor(speedposD1),y=prop.INT.var))+
#  geom_boxplot()+
#  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("Figure 1.3: Interviewer effects per interview style in Module D")+
#  labs(x="Interview type",y="Interviewer effect")+stat_summary(fun.y=mean, colour="darkred", geom="point", 
 #             shape=18, size=3,show_guide = FALSE) 





####
# module e
#####

MF.RES<-NULL
lijst<-NULL
lijst1<-NULL
for(l in 1:nrow(landen)){
  land<-as.character(landen[l,1])
  MF.l<-MFE[MFE$CNTRY==land,]
  MF.res<-MF.l[,c("CNTRY","IDNO")]
  print(land)
  
  #####
  # standaardiseer alle targetvariabelen in array.t
  #####
  MF.l[,array.Eicc]<-lapply(MF.l[,array.Eicc],fun.st)
  #for(i in 1:2){
  for(i in 1:length(array.Eicc)){
    target<-array.Eicc[i]
    MF.s1<-MF.l[,c(target,"CNTRY","ID.IND","ID.INT","lft","sexe","opl2","LANG.SAME1","opl3","speedposE","dens",
                   "REGAT11","REGAT12", "REGAT13" ,     
                   "REGAT21"     ,   "REGAT22"      ,  "REGAT31"    ,    "REGAT32"   ,     "REGAT33"      ,  "REGAT34" ,      
                   "REGBE10",        "REGBE21"  ,      "REGBE22"  ,      "REGBE23",   "REGBE24"      ,  "REGBE25", "REGBE31" ,  
                   "REGBE32"   ,     "REGBE33"     ,   "REGBE34"    ,    "REGBE35"    ,    "REGCH01"   ,     "REGCH02"    ,    "REGCH03"       ,
                   "REGCHO5"   ,     "REGCH06"   ,     "REGCH07"    ,    "REGCH08"  ,      "REGDE1"  ,       "REGDE2"     ,    "REGDE3" ,       
                   "REGDE4"   ,      "REGDE5"   ,      "REGDE6"      ,   "REGDE7"    ,     "REGDE8"      ,   "REGDE9"    ,     "REGDEA"  ,      
                   "REGDEB" ,        "REGDEC"      ,   "REGDED"       ,  "REGDEE"    ,     "REGDEF"   ,      "REGDEG"   ,      "REGDK1" ,       
                   "REGDK2"  ,       "REGDK3"    ,     "REGDK4"  ,       "REGDK5"  ,       "REGEE01"  ,      "REGEE04"      ,  "REGEE06"   ,    
                   "REGEE07"      ,  "REGEE08"    ,    "REGFI193"     ,  "REGFI194"      , "REGFI195" ,      "REGFI196" ,      "REGFI197"  ,    
                   "REGFI1B1" ,      "REGFI1C1"  ,     "REGFI1C2" ,      "REGFI1C3"  ,     "REGFI1C4"    ,   "REGFI1C5"       ,"REGFI1D1",      
                   "REGFI1D2"  ,     "REGFI1D3"    ,   "REGFI1D4"  ,     "REGFI1D5"   ,    "REGFI1D6"  ,     "REGFI1D7"  ,     "REGFI200"  ,    
                   "REGFR10"     ,   "REGFR21"    ,    "REGFR22"    ,    "REGFR23",        "REGFR24"  ,      "REGFR25"  ,      "REGFR26",       
                   "REGFR30" ,       "REGFR41"   ,     "REGFR42"   ,     "REGFR43"  ,      "REGFR51" ,       "REGFR52"  ,      "REGFR53"     ,  
                   "REGFR61"     ,   "REGFR62"    ,    "REGFR63"   ,     "REGFR71"    ,    "REGFR72"    ,    "REGFR81"    ,    "REGFR82" ,      
                   "REGHU101"  ,     "REGHU102"  ,     "REGHU211"   ,    "REGHU212" ,      "REGHU213"     ,  "REGHU221"   ,    "REGHU222"  ,    
                   "REGHU223"  ,     "REGHU231"      , "REGHU232"  ,     "REGHU233"    ,   "REGHU311"   ,    "REGHU312"      , "REGHU313" ,     
                   "REGHU321"   ,    "REGHU322"   ,    "REGHU323"     ,  "REGHU331"   ,    "REGHU332"   ,    "REGHU333"   ,    "REGIE011"  ,    
                   "REGIE012"      , "REGIE013"   ,    "REGIE021"    ,   "REGIE022"    ,   "REGIE023"   ,    "REGIE024"   ,    "REGNL11"  ,     
                   "REGNL12"   ,     "REGNL13"    ,    "REGNL21"    ,    "REGNL22"    ,    "REGNL23"    ,    "REGNL31" ,       "REGNL32"   ,    
                   "REGNL33" ,       "REGNL34"     ,   "REGNL41"   ,     "REGNL42"   ,     "REGNO001" ,      "REGNO002"    ,   "REGNO003"  ,    
                   "REGNO004"    ,   "REGNO005"    ,   "REGNO006"   ,    "REGNO007"   ,    "REGSE110"  ,     "REGSE121" ,      "REGSE122"  ,    
                   "REGSE123"  ,     "REGSE124"     ,  "REGSE125"   ,    "REGSE211"   ,    "REGSE212" ,      "REGSE213"  ,     "REGSE214"  ,    
                   "REGSE221" ,      "REGSE224" ,      "REGSE231"   ,    "REGSE232"   ,    "REGSE311"   ,    "REGSE312"     ,  "REGSE313"  ,    
                   "REGSE321" ,      "REGSE322"     ,  "REGSE331",       "REGSE332"  ,     "REGSI011"     ,  "REGSI012"    ,   "REGSI013"  , 
                   "REGSI014"  ,     "REGSI015"  ,     "REGSI016"     ,  "REGSI017"  ,     "REGSI018"     ,  "REGSI021"       ,"REGSI022"  ,    
                   "REGSI023" ,      "REGSI024"    ,   "REGUKC" ,        "REGUKD"   ,      "REGUKE",         "REGUKF"   ,      "REGUKG"    ,    
                   "REGUKH"  ,       "REGUKI"        , "REGUKJ"   ,      "REGUKK"   ,      "REGUKL"      ,   "REGUKM",   "REGUKN")]
    names(MF.s1)<-c("target","CNTRY","ID.IND","ID.INT","lft","sexe","opl2","LANG.SAME1","opl3","speedposE","dens","REGAT11","REGAT12", "REGAT13" ,     
                    "REGAT21"     ,   "REGAT22"      ,  "REGAT31"    ,    "REGAT32"   ,     "REGAT33"      ,  "REGAT34" ,      
                    "REGBE10",        "REGBE21"  ,      "REGBE22"  ,      "REGBE23",   "REGBE24"      ,  "REGBE25", "REGBE31" ,  
                    "REGBE32"   ,     "REGBE33"     ,   "REGBE34"    ,    "REGBE35"    ,    "REGCH01"   ,     "REGCH02"    ,    "REGCH03"       ,
                    "REGCHO5"   ,     "REGCH06"   ,     "REGCH07"    ,    "REGCH08"  ,      "REGDE1"  ,       "REGDE2"     ,    "REGDE3" ,       
                    "REGDE4"   ,      "REGDE5"   ,      "REGDE6"      ,   "REGDE7"    ,     "REGDE8"      ,   "REGDE9"    ,     "REGDEA"  ,      
                    "REGDEB" ,        "REGDEC"      ,   "REGDED"       ,  "REGDEE"    ,     "REGDEF"   ,      "REGDEG"   ,      "REGDK1" ,       
                    "REGDK2"  ,       "REGDK3"    ,     "REGDK4"  ,       "REGDK5"  ,       "REGEE01"  ,      "REGEE04"      ,  "REGEE06"   ,    
                    "REGEE07"      ,  "REGEE08"    ,    "REGFI193"     ,  "REGFI194"      , "REGFI195" ,      "REGFI196" ,      "REGFI197"  ,    
                    "REGFI1B1" ,      "REGFI1C1"  ,     "REGFI1C2" ,      "REGFI1C3"  ,     "REGFI1C4"    ,   "REGFI1C5"       ,"REGFI1D1",      
                    "REGFI1D2"  ,     "REGFI1D3"    ,   "REGFI1D4"  ,     "REGFI1D5"   ,    "REGFI1D6"  ,     "REGFI1D7"  ,     "REGFI200"  ,    
                    "REGFR10"     ,   "REGFR21"    ,    "REGFR22"    ,    "REGFR23",        "REGFR24"  ,      "REGFR25"  ,      "REGFR26",       
                    "REGFR30" ,       "REGFR41"   ,     "REGFR42"   ,     "REGFR43"  ,      "REGFR51" ,       "REGFR52"  ,      "REGFR53"     ,  
                    "REGFR61"     ,   "REGFR62"    ,    "REGFR63"   ,     "REGFR71"    ,    "REGFR72"    ,    "REGFR81"    ,    "REGFR82" ,      
                    "REGHU101"  ,     "REGHU102"  ,     "REGHU211"   ,    "REGHU212" ,      "REGHU213"     ,  "REGHU221"   ,    "REGHU222"  ,    
                    "REGHU223"  ,     "REGHU231"      , "REGHU232"  ,     "REGHU233"    ,   "REGHU311"   ,    "REGHU312"      , "REGHU313" ,     
                    "REGHU321"   ,    "REGHU322"   ,    "REGHU323"     ,  "REGHU331"   ,    "REGHU332"   ,    "REGHU333"   ,    "REGIE011"  ,    
                    "REGIE012"      , "REGIE013"   ,    "REGIE021"    ,   "REGIE022"    ,   "REGIE023"   ,    "REGIE024"   ,    "REGNL11"  ,     
                    "REGNL12"   ,     "REGNL13"    ,    "REGNL21"    ,    "REGNL22"    ,    "REGNL23"    ,    "REGNL31" ,       "REGNL32"   ,    
                    "REGNL33" ,       "REGNL34"     ,   "REGNL41"   ,     "REGNL42"   ,     "REGNO001" ,      "REGNO002"    ,   "REGNO003"  ,    
                    "REGNO004"    ,   "REGNO005"    ,   "REGNO006"   ,    "REGNO007"   ,    "REGSE110"  ,     "REGSE121" ,      "REGSE122"  ,    
                    "REGSE123"  ,     "REGSE124"     ,  "REGSE125"   ,    "REGSE211"   ,    "REGSE212" ,      "REGSE213"  ,     "REGSE214"  ,    
                    "REGSE221" ,      "REGSE224" ,      "REGSE231"   ,    "REGSE232"   ,    "REGSE311"   ,    "REGSE312"     ,  "REGSE313"  ,    
                    "REGSE321" ,      "REGSE322"     ,  "REGSE331",       "REGSE332"  ,     "REGSI011"     ,  "REGSI012"    ,   "REGSI013"  , 
                    "REGSI014"  ,     "REGSI015"  ,     "REGSI016"     ,  "REGSI017"  ,     "REGSI018"     ,  "REGSI021"       ,"REGSI022"  ,    
                    "REGSI023" ,      "REGSI024"    ,   "REGUKC" ,        "REGUKD"   ,      "REGUKE",         "REGUKF"   ,      "REGUKG"    ,    
                    "REGUKH"  ,       "REGUKI"        , "REGUKJ"   ,      "REGUKK"   ,      "REGUKL"      ,   "REGUKM",   "REGUKN")
    
    #####
    # Bereken per target variabele in elke land de residuelen van regressie met achtergrond var. als covariaten.
    #####
    
    
    
    
    for(speedposE in -1:1){
      MF.s2<-MF.s1[MF.s1$speedposE==speedposE,]
      
      #####
      # Bereken binnen elke groep van interviewers the var. componenten
      #####
      
      m1<-lmer(target~lft+sexe+opl2+opl3+LANG.SAME1+
      REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
        REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
        REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
        REGDED+REGDEE+REGDEF+REGDEG+
        REGDK2+REGDK3+REGDK4+REGDK5+
        REGEE01+REGEE04++REGEE07+REGEE08+
        REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
        +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
        REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
        REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
        REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
        REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
        REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
        REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
        REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
        REGSI023+REGSI024
      +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN+(1|ID.INT),data=MF.s2)
      lijn1<-cbind(unlist(VarCorr(m1)),(attr(VarCorr(m1), "sc"))^2,speedposE)
      row.names(lijn1)<-paste(land,target)
      lijst1<-rbind(lijst1,lijn1)
    }
    
  }
  
}



lijst1<-as.data.frame(lijst1)
lijst1$target<-substr(row.names(lijst1),3,15)
lijst1$CNTRY<-substr(row.names(lijst1),1,2)

row.names(lijst1)<-NULL
names(lijst1)<-c("INT.var","ERR","speedposE","TARGET","CNTRY")
lijst1$prop.ERR<-lijst1$ERR/(lijst1$ERR+lijst1$INT.var)
lijst1$prop.INT.var<-lijst1$INT.var/(lijst1$ERR+lijst1$INT.var)
lijst1$ICC<-lijst1$prop.INT.var*100
lijst1$sGRB<-ifelse(lijst1$speedposE==-1,2,lijst1$speedposE)
lijst1$traag<-ifelse(lijst1$speedposE==-1,1,0)
lijst1$snel<-ifelse(lijst1$speedposE==1,1,0)
lijst1<-lijst1[order(lijst1$CNTRY,lijst1$sGRB),]



ICC2<-lmer(ICC~traag+snel+(0+traag+snel|CNTRY)+(1|TARGET),data=lijst1)
summary(ICC2)
rand(ICC2)

ICC1<-lmer(ICC~traag+snel+(traag+snel|CNTRY)+(1|TARGET),data=lijst1,REML=F)
summary(ICC1)
rand(ICC1)
b<-ranef(ICC1, condVar=TRUE)
rdeffectE<-as.data.frame(b[1])

c<-as.data.frame(fixef(ICC1))
rdeffectE$expmoderatE<-rdeffectE$CNTRY..Intercept+c[1,1]
rdeffectE$expsnelE<-rdeffectE$CNTRY..Intercept+c[1,1]+rdeffectE$CNTRY.snel+c[3,1]
rdeffectE$exptraafE<-rdeffectE$CNTRY..Intercept+c[1,1]+rdeffectE$CNTRY.traag+c[2,1]

anova(ICC1,ICC2)

ICC2<-lmer(ICC~traag+snel+(0+traag+snel|CNTRY)+(1|TARGET),data=lijst1[which(!lijst1$CNTRY=="HU"),],REML=F)
summary(ICC2)
rand(ICC2)

ICC1<-lmer(ICC~traag+snel+(traag+snel|CNTRY)+(1|TARGET),data=lijst1[which(!lijst1$CNTRY=="HU"),],REML=F)
summary(ICC1)
rand(ICC1)

anova(ICC1,ICC2)

lijst1$CNTRYplot<-revalue(lijst1$CNTRY, c("AT"="Austria","BE"="Belgium","DK"="Denmark","EE"="Estonia","FI"="Finland"
                                          ,"FR"="France","HU"="Hungary","IE"="Ireland","DE"="Germany","NL"="The Netherlands","NO"="Norway"
                                          ,"SI"="Slovenia","SE"="Sweden","CH"="Switzerland","GB"="The UK"))
lijst1$speedposE1<-ifelse(lijst1$speedposE==-1,"Slow",ifelse(lijst1$speedposE==1,"Fast","Mod."))

ICCEmean<-lijst1 %>% group_by(CNTRYplot,speedposE1)%>% summarise(meanICC=mean(ICC,na.rm=T),
                                                                 sdICC=sd(ICC,na.rm=T))

ICCEdifferences<-lijst1[,c("CNTRYplot","speedposE1", "TARGET", "ICC")] 
ICCEdifferences_wide<-ICCEdifferences %>% spread(speedposE1, ICC)
ICCEdifferences_wide$slow_moderate<- ICCEdifferences_wide$Slow-ICCEdifferences_wide$Mod.
ICCEdifferences_wide$fast_moderate<- ICCEdifferences_wide$Fast-ICCEdifferences_wide$Mod.
ICCEdifferences_mean <-ICCEdifferences_wide %>% group_by(CNTRYplot)%>% summarise(meanSM=mean(slow_moderate,na.rm=T),
                                                                                 sdSM=sd(slow_moderate,na.rm=T),
                                                                                 meanFM=mean(fast_moderate,na.rm=T),
                                                                                 sdFM=sd(fast_moderate, na.rm=T))

ICCEdifferences_long <- ICCEdifferences_wide[, c('CNTRYplot','TARGET','slow_moderate', 'fast_moderate')] %>% gather(slow_fast, ICC_differences, -CNTRYplot, -TARGET)
ggplot(data=ICCEdifferences_long,aes(x = CNTRYplot, y = ICC_differences, fill = slow_fast)) +      
  geom_boxplot() +
  # stat_summary(fun.y=mean, colour="darkred", geom="point", 
  #              shape=18, size=3,show_guide = FALSE) + 
  labs(x="Countries",y="Difference in ICC") +
  theme(legend.position = c(0.9, 0.9))+ guides(fill=guide_legend(title=NULL)) +
  scale_fill_discrete(name=" ", breaks=c("fast_moderate", "slow_moderate"), labels=c("Fast vs moderate", "Slow vs moderate")) +
  theme(axis.text.x = element_text(angle=60, hjust=1))

#ggplot(data=lijst1,aes(x=factor(speedposE1),y=prop.INT.var))+

 # geom_boxplot()+
#  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("Figure 1.4: Interviewer effects per interview style in Module E")+
#  labs(x="Interview type",y="Interviewer effect")+stat_summary(fun.y=mean, colour="darkred", geom="point", 
 #                                                              shape=18, size=3,show_guide = FALSE)

#sum<-aggregate(cbind(INT.var,ERR,prop.INT.var,prop.ERR)~speedposE+CNTRY,data=lijst1,mean)


#sum$CNTRY<-factor(sum$CNTRY,levels=c("AT","BE","DK","EE","FI","FR","HU","IE","DE","NL","NO","SI","SE","CH","GB"))
#ggplot(data=sum,aes(x=speedposE))+
 # geom_point(aes(y=prop.INT.var),color="red")+
#  geom_line(aes(y=prop.INT.var),color="red")+
 # facet_wrap(~CNTRY,ncol=5)+ggtitle("Mean ICC over 16 variabelen split per mean speed from module E")

rdeffectB$cntr<-row.names(rdeffectB)
rdeffectB$Module<-"B"
names(rdeffectB)<-c("Intercept", "Sloweffect","Fasteffect", "Mod.", "Fast","Slow" ,"Cntry","Module")
longB<-rdeffectB %>% gather(Speedtype,Speed, Mod.:Slow)

rdeffectC$cntr<-row.names(rdeffectC)
rdeffectC$Module<-"C"
names(rdeffectC)<-c("Intercept", "Sloweffect","Fasteffect", "Mod.", "Fast","Slow" ,"Cntry","Module")
longC<-rdeffectC %>% gather(Speedtype,Speed, Mod.:Slow)

rdeffectD$cntr<-row.names(rdeffectD)
rdeffectD$Module<-"D"
names(rdeffectD)<-c("Intercept", "Sloweffect","Fasteffect", "Mod.", "Fast","Slow" ,"Cntry","Module")
longD<-rdeffectD %>% gather(Speedtype,Speed, Mod.:Slow)

rdeffectE$cntr<-row.names(rdeffectE)
rdeffectE$Module<-"E"
names(rdeffectE)<-c("Intercept", "Sloweffect","Fasteffect", "Mod.", "Fast","Slow" ,"Cntry","Module")
longE<-rdeffectE %>% gather(Speedtype,Speed, Mod.:Slow)

rdeffect<-full_join(longB,longC)
rdeffect<-full_join(rdeffect,longD)
rdeffect<-full_join(rdeffect,longE)

mean(rdeffect[which(rdeffect$Speedtype=="Fast"),]$Speed)

rdeffect$CNTRYplot<-revalue(rdeffect$Cntry, c("AT"="Austria","BE"="Belgium","DK"="Denmark","EE"="Estonia","FI"="Finland"
                                          ,"FR"="France","HU"="Hungary","IE"="Ireland","DE"="Germany","NL"="The Netherlands","NO"="Norway"
                                          ,"SI"="Slovenia","SE"="Sweden","CH"="Switzerland","GB"="The UK"))

ggplot(data=rdeffect, aes(x=Speedtype,y= Speed,colour=Module, group=Module))+
  geom_point()+
  geom_line()+
  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("")+
  labs(x="Interview type",y="Expected interviewer effect")+
  theme(legend.position="bottom")+
  theme(axis.text.x = element_text(angle=60, hjust=1))

ggplot(data=rdeffect[which(!rdeffect$Cntry %in% c("SI","HU")),], aes(x=Speedtype,y= Speed,colour=Module, group=Module))+
  geom_point()+
  geom_line()+
  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("")+
  labs(x="Interview Speed",y="Expected Interviewer effect")

ggplot(data=rdeffect[which(rdeffect$Cntry %in% c("SI","HU")),], aes(x=Speedtype,y= Speed,colour=Module, group=Module))+
  geom_point()+
  geom_line()+
  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("")+
  labs(x="Interview Speed",y="Expected Interviewer effect")

ICCBmean$Module<-"B"
names(ICCBmean)<-c("CNTRYplot","Speedtype","ICC","sd","Module")
ICCCmean$Module<-"C"
names(ICCCmean)<-c("CNTRYplot","Speedtype","ICC","sd","Module")
ICCDmean$Module<-"D"
names(ICCDmean)<-c("CNTRYplot","Speedtype","ICC","sd","Module")
ICCEmean$Module<-"E"
names(ICCEmean)<-c("CNTRYplot","Speedtype","ICC","sd","Module")

ICCmean<-full_join(ICCBmean,ICCCmean)
ICCmean<-full_join(ICCmean,ICCDmean)
ICCmean<-full_join(ICCmean,ICCEmean)

ICCmean$ymin<-max(ICCmean$ICC-1.96*ICCmean$sd)
ICCmean$ymax<-ICCmean$ICC+1.96*ICCmean$sd


ggplot(data=ICCmean, aes(x=Speedtype,y= ICC,colour=Module, group=Module))+
  geom_point()+
  #geom_line()+
  geom_errorbar(aes(x=ICCmean$Speedtype,ymax=ICCmean$ymax,ymin=ICCmean$ymin, group=ICCmean$Module))+
  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("")+
  labs(x="Interview type",y="Mean Interviewer effect")+
  theme(legend.position="bottom")+
  theme(axis.text.x = element_text(angle=60, hjust=1))
ggplt(data= ICCBdifferences_wide)

ggplot(data=ICCmean[which(ICCmean$CNTRYplot %in% c("Slovenia","Hungary")),], aes(x=Speedtype,y= ICC,colour=Module, group=Module))+
  geom_point()+
  geom_line()+
  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("")+
  labs(x="Interview type",y="Mean Interviewer effect")


ICCBdifferences_wide$Module<-"B"
names(ICCBmean)<-c("CNTRYplot","Diff_slow_mod","sd_Diff_slow_mod","Diff_fast_mod","sd_Diff_fast_mod","Module")
ICCCmean$Module<-"C"
names(ICCCmean)<-c("CNTRYplot","Speedtype","ICC","sd","Module")
ICCDmean$Module<-"D"
names(ICCDmean)<-c("CNTRYplot","Speedtype","ICC","sd","Module")
ICCEmean$Module<-"E"
names(ICCEmean)<-c("CNTRYplot","Speedtype","ICC","sd","Module")

ICCmean<-full_join(ICCBmean,ICCCmean)
ICCmean<-full_join(ICCmean,ICCDmean)
ICCmean<-full_join(ICCmean,ICCEmean)

ICCmean$ymin<-max(ICCmean$ICC-1.96*ICCmean$sd)
ICCmean$ymax<-ICCmean$ICC+1.96*ICCmean$sd


ggplot(data=ICCmean, aes(x=Speedtype,y= ICC,colour=Module, group=Module))+
  geom_point()+
  geom_line()+
  #geom_errorbar(aes(x=ICCmean$Speedtype,ymax=ICCmean$ymax,ymin=ICCmean$ymin, group=ICCmean$Module))+
  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("")+
  labs(x="Interview type",y="Mean interviewer effect")+
  theme(legend.position="bottom")+
  theme(axis.text.x = element_text(angle=60, hjust=1))


ggplot(data=ICCmean[which(ICCmean$CNTRYplot %in% c("Slovenia","Hungary")),], aes(x=Speedtype,y= ICC,colour=Module, group=Module))+
  geom_point()+
  geom_line()+
  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("")+
  labs(x="Interview type",y="Mean Interviewer effect")